﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Fundusz - wpłaty</title>
		<script runat="server">

	void OnContextLoad(object sender, EventArgs args) {
		DefinicjaFunduszuPozyczkowego def = (DefinicjaFunduszuPozyczkowego)dc[typeof(DefinicjaFunduszuPozyczkowego)];
        FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
		ReportHeader1["FUNDUSZ"] = def==null ? "?" : def.ToString();
		ReportHeader1["OKRES"] = okres.ToString();
		
		ArrayList result = new ArrayList();
		Row[] rows = (Row[])dc[typeof(Row[])];	
		foreach (FundPozyczkowy fp in rows)
			foreach (Pozyczka pożyczka in fp.Pozyczki)
				foreach (WypElement e in pożyczka.RazemElementy)
                    if (okres.Contains(e.Data) && e.RodzajZrodla == RodzajŹródłaWypłaty.PożyczkaSpłata)
						result.Add(e);
		Grid1.DataSource = result;
	}
	
	void OnBeforeRow(object sender, RowEventArgs args) {
		wartość.EditValue = - ((WypElement)args.Row).Wartosc;
	}

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="FunduszWpłaty" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="%FUNDUSZ% - RATY POŻYCZEK|W okresie: %OKRES%" runat="server"></cc1:reportheader>
			<ea:grid id="Grid1" runat="server" RowTypeName="Soneta.Place.WypElement,Soneta.KadryPlace" onbeforerow="OnBeforeRow" Sort="Pracownik.Kod,Data">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Pracownik.Kod" Caption="Kod" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="35" DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Align="Center" DataMember="Data" Caption="Rata~Data spłaty"></ea:GridColumn>
					<ea:GridColumn Width="22" DataMember="Nazwa" Total="Info" Caption="Rata~Nazwa" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Right" Total="Sum" Caption="Rata~Wartość" Format="{0:n}" ID="wartość"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter></form>
	</body>
</HTML>

